<?php 
/**
 * Run any controller action from the shell.
 * 
 * For Cakephp ver 1.3 (untested in other versions)
 * 
 * @link	https://gist.github.com/3693790#comments
 * 
 * Place in ~/path_to_cake/app/venders/shells
 * 
 * Execution:
 * 
 * ~/path_to_cake/app/vendors/cakeshell run_any_action controller_name action_name -cli /usr/bin -console ~/path_to_cake/cake/console -app ~/path_to_cake/app
 */



class RunnyShell extends Shell {
    var $tasks = array('Project', 'DbConfig',
                 'Model', 'Controller', 'View', 'Plugin');

    function initialize() {
       $this->_loadModels();
    }

    function main() {
	
	// get controller name from args
	if (isset($this->args[0])){
		$controller = $this->args[0];
	}else{
		echo 'No Controller Given';
		return false;
	}
	
	App::import('Controller', $controller,'Core');
	
	//make controller name conform to Cake standards:
	$controller=Inflector::camelize($controller).'Controller';
	
	// get action name from args
	if (isset($this->args[1])){
		$action = $this->args[1];
	}else{
		echo 'No Action Given';
		return false;
	}
	
	//make instance of controller
	$this->PlaceholderController = new $controller();
	
	//construct controller classes
	$this->PlaceholderController->ConstructClasses();
	
	//execute action
	$this->PlaceholderController->$action();
    }

    
}
?>